/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property;

public class VWTime {
    public static final int SECONDS = -1;
    public static final int MINUTES = 0;
    public static final int HOURS = 1;
    public static final int DAYS = 2;
    public static final int WEEKS = 3;
    protected long m_time;
    protected int m_unit;

    public VWTime() {
        this.m_time = 0L;
        this.m_unit = -1;
    }

    public VWTime(long time, int unit) {
        this.m_time = time;
        this.m_unit = unit;
    }

    public void setTimeUnit(long time, int unit) {
        this.m_time = time;
        this.m_unit = unit;
    }

    public long getTime() {
        return this.m_time;
    }

    public int getUnit() {
        return this.m_unit;
    }

    public boolean convertTime(int newUnit) {
        boolean result = true;
        switch (newUnit) {
            case -1: {
                result = this.convertTimeToSeconds();
                break;
            }
            case 0: {
                result = this.convertTimeToMinutes();
                break;
            }
            case 1: {
                result = this.convertTimeToHours();
                break;
            }
            case 2: {
                result = this.convertTimeToDays();
                break;
            }
            case 3: {
                result = this.convertTimeToWeeks();
            }
        }
        return result;
    }

    private boolean convertTimeToSeconds() {
        boolean result = false;
        switch (this.m_unit) {
            case -1: {
                result = true;
                break;
            }
            case 0: {
                this.m_time *= 60L;
                result = true;
                this.m_unit = -1;
                break;
            }
            case 1: {
                this.m_time = this.m_time * 60L * 60L;
                result = true;
                this.m_unit = -1;
                break;
            }
            case 2: {
                this.m_time = this.m_time * 60L * 60L * 24L;
                result = true;
                this.m_unit = -1;
                break;
            }
            case 3: {
                this.m_time = this.m_time * 60L * 60L * 24L * 7L;
                result = true;
                this.m_unit = -1;
            }
        }
        return result;
    }

    private boolean convertTimeToMinutes() {
        boolean result = false;
        switch (this.m_unit) {
            case -1: {
                boolean bl = result = this.m_time % 60L == 0L;
                if (result) {
                    this.m_time /= 60L;
                    this.m_unit = 0;
                }
            }
            case 0: {
                result = true;
                break;
            }
            case 1: {
                this.m_time *= 60L;
                result = true;
                this.m_unit = 0;
                break;
            }
            case 2: {
                this.m_time = this.m_time * 60L * 24L;
                result = true;
                this.m_unit = 0;
                break;
            }
            case 3: {
                this.m_time = this.m_time * 60L * 24L * 7L;
                result = true;
                this.m_unit = 0;
            }
        }
        return result;
    }

    private boolean convertTimeToHours() {
        boolean result = false;
        switch (this.m_unit) {
            case -1: {
                boolean bl = result = this.m_time % 3600L == 0L;
                if (!result) break;
                this.m_time = this.m_time / 60L / 60L;
                this.m_unit = 1;
                break;
            }
            case 0: {
                boolean bl = result = this.m_time % 60L == 0L;
                if (!result) break;
                this.m_time /= 60L;
                this.m_unit = 1;
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 2: {
                this.m_time *= 24L;
                result = true;
                this.m_unit = 1;
                break;
            }
            case 3: {
                this.m_time = this.m_time * 24L * 7L;
                result = true;
                this.m_unit = 1;
            }
        }
        return result;
    }

    private boolean convertTimeToDays() {
        boolean result = false;
        switch (this.m_unit) {
            case -1: {
                boolean bl = result = this.m_time % 86400L == 0L;
                if (!result) break;
                this.m_time = this.m_time / 60L / 60L / 24L;
                this.m_unit = 2;
                break;
            }
            case 0: {
                boolean bl = result = this.m_time % 1440L == 0L;
                if (!result) break;
                this.m_time = this.m_time / 60L / 24L;
                this.m_unit = 2;
                break;
            }
            case 1: {
                boolean bl = result = this.m_time % 24L == 0L;
                if (!result) break;
                this.m_time /= 24L;
                this.m_unit = 2;
                break;
            }
            case 2: {
                result = true;
                break;
            }
            case 3: {
                this.m_time *= 7L;
                this.m_unit = 2;
                result = true;
            }
        }
        return result;
    }

    private boolean convertTimeToWeeks() {
        boolean result = false;
        switch (this.m_unit) {
            case -1: {
                boolean bl = result = this.m_time % 604800L == 0L;
                if (result) {
                    this.m_time = this.m_time / 60L / 60L / 24L / 7L;
                    this.m_unit = 3;
                }
            }
            case 0: {
                boolean bl = result = this.m_time % 10080L == 0L;
                if (!result) break;
                this.m_time = this.m_time / 60L / 24L / 7L;
                this.m_unit = 3;
                break;
            }
            case 1: {
                boolean bl = result = this.m_time % 168L == 0L;
                if (!result) break;
                this.m_time = this.m_time / 24L / 7L;
                this.m_unit = 3;
                break;
            }
            case 2: {
                boolean bl = result = this.m_time % 7L == 0L;
                if (!result) break;
                this.m_time /= 7L;
                this.m_unit = 3;
                break;
            }
            case 3: {
                result = true;
            }
        }
        return result;
    }
}

